Name:           zsync2
Version:        2.0.0
Release:        alpha-1
Source:         zsync2_2.0.0-alpha-1.tar.gz
Url:            https://github.com/AppImage/zsync2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  automake
BuildRequires:  cmake
BuildRequires:  openssl-devel
BuildRequires:  libssh-devel
BuildRequires:  libcurl-devel
BuildRequires:  zlib-devel
Summary:        A rewrite of the advanced file download/sync tool zsync.
License:        Artistic-2.0
Group:          Productivity/Networking/Other

%global debug_package %{nil}

%description
The rewrite changes fundamental principles of how zsync works.
For example, the new code will be C++11.
Furthermore, the entire functionality will be bundled in a single library called libzsync2.
The library will serve as a base for the new zsync2 main binary,
but can then also be linked by other projects which seek to make use of the algorithms and functionality in it.
This project is intended to remain compatible to the original zsync, i.e.,
the zsync file format will stay the same etc. However, the zsync file format
should be extended to be able to serve additional purposes as well.
Such purposes could be e.g., adding meta information like version numbers, etc.

%prep
%setup -q -n zsync2

%build
cmake -DCMAKE_INSTALL_PREFIX=/usr -DUSE_SYSTEM_CURL=1 -DBUILD_CPR_TESTS=0
%__make %{?jobs:-j%{jobs}}

%install
make DESTDIR=%{buildroot} install

%clean

%files
%defattr(-,root,root)
%doc COPYING README.md
%{_bindir}/zsync2
%{_bindir}/zsyncmake2
%exclude /usr/lib/static/libzsync2.a

%changelog
* Tue Sep 14 2021 info@uib.de
- New upstream release
